<div class="wrap">
	<h1>مدیریت دیدار</h1>
	<?php

	//var_dump(didar_api::get_product_by_code('1020'));
	//$ord = didar_api::save_order(187);
	/*if(isset($didar->Error))
		update_post_meta($order_id,'didar_msg',$didar->Error);
var_dump($ord);*/
	//var_dump(didar_api::has_product('محصول تست'));
	//var_dump(didar_api::get_category());
	//var_dump(didar_api::has_user('اردلان شجاع کاوه'));
	//var_dump(didar_api::get_kariz_list());
	// Handle manual cron test
	if(isset($_POST['test_cron']) && check_admin_referer('didar_test_cron')){
		if(function_exists('didar_send_all_order_function')){
			didar_send_all_order_function();
			echo '<div id="setting-error-settings_updated" class="notice notice-success settings-error is-dismissible"><p><strong>اجرای دستی cron انجام شد.</strong> لطفا بخش "وضعیت ارسال دوره‌ای" را بررسی کنید.</p></div>';
		}
	}
	
	if(isset($_POST['save'])){
		// Validate user selection (only required if API is valid and users list is available)
		$users = isset($_POST['user']) ? $_POST['user'] : [];
		if(!is_array($users)){
			$users = !empty($users) ? [$users] : [];
		}
		
		// Check if API code is valid and users list is available
		// Temporarily update option to test with new API code
		$api_code = isset($_POST['didar_api']) ? trim($_POST['didar_api']) : '';
		$users_list_available = false;
		if(!empty($api_code)){
			// Temporarily save API code to test
			$old_opt = get_option('did_option', []);
			$temp_opt = $old_opt;
			$temp_opt['didar_api'] = $api_code;
			update_option('did_option', $temp_opt);
			
			// Try to get users list with new API code
			$users_list = didar_api::get_user_list();
			$users_list_available = !empty($users_list) && is_array($users_list) && count($users_list) > 0;
			
			// Restore old option (will be updated properly later if validation passes)
			update_option('did_option', $old_opt);
		}
		
		// Only require users if API is valid and users list is available
		if($users_list_available && empty($users)){
			echo '<div id="setting-error-settings_updated" class="notice notice-error settings-error is-dismissible"><p><strong>خطا:</strong> تعیین مسئول معامله اجباری است. لطفا حداقل یک کاربر را انتخاب کنید.</p></div>';
		} else {
			// Process status configuration
			$status_config = [];
			if(isset($_POST['status_enabled']) && is_array($_POST['status_enabled'])){
				foreach($_POST['status_enabled'] as $status_key => $enabled){
					if($enabled == '1' && isset($_POST['status_deal_type'][$status_key])){
						$status_config[$status_key] = intval($_POST['status_deal_type'][$status_key]);
					}
				}
			}
			$_POST['status_config'] = $status_config;
			// Generate status array for backward compatibility
			$_POST['status'] = array_keys($status_config);
			// Save users as array
			$_POST['user'] = $users;
			// Handle checkbox: if not set, set to empty string
			if(!isset($_POST['soid'])){
				$_POST['soid'] = '';
			}
			// Ensure order_count and order_start are saved properly
			if(isset($_POST['order_count'])){
				$_POST['order_count'] = intval($_POST['order_count']);
				if($_POST['order_count'] < 1){
					$_POST['order_count'] = 20; // Default value
				}
			} else {
				$_POST['order_count'] = 20; // Default value
			}
			if(isset($_POST['order_start'])){
				$_POST['order_start'] = intval($_POST['order_start']);
				if($_POST['order_start'] < 0){
					$_POST['order_start'] = 0;
				}
			} else {
				$_POST['order_start'] = 0; // Default value
			}
			update_option( 'did_option', $_POST );
			
			// Reschedule cron if needed
			if(function_exists('didar_schedule_cron')){
				didar_schedule_cron();
			}
			
			echo '<div id="setting-error-settings_updated" class="notice notice-success settings-error is-dismissible"><p><strong>تنظیمات ذخیره شد.</strong></p></div>';
		}
	}
	$opt    = get_option( 'did_option', [] );
	$status = empty($opt['status'])?[]:$opt['status'];
	$status_config = empty($opt['status_config'])?[]:$opt['status_config'];
	$type   = empty($opt['send_type'])?1:$opt['send_type'];
	$cron_interval = isset($opt['cron_interval'])?$opt['cron_interval']:'5min';
	$soid   = empty($opt['soid'])?'':$opt['soid'];
	$currency_type = isset($opt['currency_type']) ? $opt['currency_type'] : get_option('woocommerce_currency', 'IRR');
	
	// Get cron status information
	$cron_last_run = get_option('didar_cron_last_run', null);
	$cron_next_run = wp_next_scheduled('didar_send_all_order_cron');
	$cron_is_scheduled = $cron_next_run !== false;
	
	// Get all WooCommerce order statuses
	$wc_statuses = wc_get_order_statuses();
	?>
	<form method="POST" dir="rtl">
		<div class="didar-settings-wrapper">
			<div class="didar-settings-header">
				<h2>تنظیمات اتصال به دیدار</h2>
				<p class="description">تنظیمات مربوط به اتصال و همگام‌سازی با سیستم CRM دیدار</p>
			</div>
			
			<div class="didar-settings-section">
				<h3 class="didar-section-title">اطلاعات اتصال</h3>
				<table class="form-table" role="presentation">
					<tr>
						<th scope="row">
							<label for="didar_api">کد API دیدار</label>
						</th>
						<td>
							<input type="text" id="didar_api" name="didar_api" dir="ltr" class="regular-text" value="<?php echo isset($opt['didar_api'])?esc_attr($opt['didar_api']):''; ?>" />
							<p class="description">کد API دریافتی از پنل دیدار را در اینجا وارد کنید</p>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="currency_type">نوع ارز</label>
						</th>
						<td>
							<select id="currency_type" name="currency_type" class="regular-text">
								<option value="IRR" <?php selected($currency_type, 'IRR'); ?>>ریال (IRR)</option>
								<option value="IRT" <?php selected($currency_type, 'IRT'); ?>>تومان (IRT)</option>
							</select>
							<p class="description">
								<strong>نوع ارز فروشگاه:</strong> اگر ارز فروشگاه شما <strong>تومان (IRT)</strong> است، این گزینه را انتخاب کنید. 
								در این صورت، قیمت‌های ارسالی به دیدار به صورت خودکار در 10 ضرب می‌شوند تا به ریال تبدیل شوند. 
								اگر ارز فروشگاه شما <strong>ریال (IRR)</strong> است، نیازی به تغییر نیست.
							</p>
						</td>
					</tr>
				</table>
			</div>
			
			<div class="didar-settings-section">
				<h3 class="didar-section-title">تنظیمات ارسال</h3>
				<table class="form-table" role="presentation">
					<tr>
						<th scope="row">نوع ارسال</th>
						<td>
							<fieldset>
								<label>
									<input type="radio" name="send_type" value="1" id="send_type_1" <?php echo checked('1',$type) ?>/> 
									<span>دوره‌ای</span>
								</label>
								<p class="description" style="margin-right: 25px;">ارسال خودکار سفارش‌ها در بازه زمانی مشخص</p>
								<br />
								<label>
									<input type="radio" name="send_type" value="3" id="send_type_3" <?php echo checked('3',$type) ?>/> 
									<span>ارسال در لحظه</span>
								</label>
								<p class="description" style="margin-right: 25px;">ارسال فوری سفارش‌ها در لحظه تغییر وضعیت</p>
								<br />
								<label>
									<input type="radio" name="send_type" value="2" id="send_type_2" <?php echo checked('2',$type) ?>/> 
									<span>دستی</span>
								</label>
								<p class="description" style="margin-right: 25px;">ارسال فقط از طریق رابط کاربری</p>
							</fieldset>
						</td>
					</tr>
					<tr id="cron_interval_row" style="display: <?php echo ($type == '1') ? 'table-row' : 'none'; ?>;">
						<th scope="row">
							<label for="cron_interval">بازه زمانی ارسال دوره‌ای</label>
						</th>
						<td>
							<select id="cron_interval" name="cron_interval" class="regular-text">
								<option value="1min" <?php selected($cron_interval, '1min'); ?>>1 دقیقه</option>
								<option value="5min" <?php selected($cron_interval, '5min'); ?>>5 دقیقه</option>
								<option value="10min" <?php selected($cron_interval, '10min'); ?>>10 دقیقه</option>
								<option value="30min" <?php selected($cron_interval, '30min'); ?>>30 دقیقه</option>
								<option value="1hour" <?php selected($cron_interval, '1hour'); ?>>1 ساعت</option>
								<option value="5hour" <?php selected($cron_interval, '5hour'); ?>>5 ساعت</option>
							</select>
							<p class="description">در این بازه زمانی، سفارش‌های جدید به صورت خودکار به دیدار ارسال می‌شوند.</p>
						</td>
					</tr>
				</table>
			</div>
			
			<div class="didar-settings-section">
				<h3 class="didar-section-title">وضعیت‌های ارسال</h3>
				<table class="form-table" role="presentation">
					<tr>
						<th scope="row">ارسال وضعیت</th>
						<td>
							<div class="didar-status-table-wrapper">
								<table class="widefat didar-status-table">
									<thead>
										<tr>
											<th style="width: 50px; text-align: center;">فعال</th>
											<th>وضعیت سفارش</th>
											<th>نوع معامله در دیدار</th>
										</tr>
									</thead>
									<tbody>
							<?php 
							foreach($wc_statuses as $status_key => $status_label):
								$is_enabled = isset($status_config[$status_key]);
								$deal_type = isset($status_config[$status_key]) ? $status_config[$status_key] : 0;
								// For backward compatibility, check old status array
								if(!$is_enabled && in_array($status_key, $status)){
									$is_enabled = true;
									// Set default deal type based on old logic
									if($status_key == 'wc-completed'){
										$deal_type = 1; // موفق
									} elseif(in_array($status_key, ['wc-cancelled', 'wc-refunded', 'wc-failed'])){
										$deal_type = 2; // ناموفق
									} else {
										$deal_type = 0; // جاری
									}
								}
							?>
							<tr>
								<td>
									<input type="checkbox" 
										   name="status_enabled[<?php echo esc_attr($status_key); ?>]" 
										   value="1" 
										   <?php echo $is_enabled ? 'checked="checked"' : ''; ?>
										   class="status-enable-checkbox"/>
								</td>
								<td>
									<label><?php echo esc_html($status_label); ?></label>
								</td>
								<td>
									<select name="status_deal_type[<?php echo esc_attr($status_key); ?>]" 
											class="status-deal-type-select" 
											<?php echo !$is_enabled ? 'disabled' : ''; ?>
											data-status-key="<?php echo esc_attr($status_key); ?>">
										<option value="0" <?php echo $deal_type == 0 ? 'selected' : ''; ?>>جاری</option>
										<option value="1" <?php echo $deal_type == 1 ? 'selected' : ''; ?>>موفق</option>
										<option value="2" <?php echo $deal_type == 2 ? 'selected' : ''; ?>>ناموفق</option>
									</select>
								</td>
							</tr>
									<?php endforeach; ?>
									</tbody>
								</table>
								<p class="description" style="margin-top: 10px;">
									برای هر وضعیت می‌توانید تعیین کنید که آیا به دیدار ارسال شود و چه نوع معامله‌ای در دیدار ساخته شود.
								</p>
							</div>
						</td>
					</tr>
				</table>
			</div>
			
			<div class="didar-settings-section">
				<h3 class="didar-section-title">تنظیمات معامله</h3>
				<table class="form-table" role="presentation">
					<tr>
						<th scope="row">
							<label for="parentSelect">انتخاب کاریز</label>
						</th>
						<td>
							<select id="parentSelect" name="parent_kariz" class="regular-text">
								<option value="">انتخاب کاریز...</option>
							</select>
							<select id="childSelect" name="kariz" class="regular-text" style="margin-top: 10px;">
								<option value="">انتخاب مرحله...</option>
							</select>
							<p class="description">کاریز و مرحله مورد نظر برای معاملات را انتخاب کنید</p>
					<!--select name="kar iz">
<option value="">انتخاب</option>
<?php
/*if($kariz = didar_api::get_kariz_list()){
                        $selected = isset($opt['kariz'])?$opt['kariz']:'';
                        foreach($kariz as $kar){
                            foreach($kar->Stages as $stage){
								echo "<option value='$stage->Id' ".($selected==$stage->Id?"selected='selected'":'').">$kar->Title-$stage->Title</option>";	
							}

                        }
                    }*/
?>
</select-->
				</td>
			</tr>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="user">انتخاب کاربر <span id="user_required_asterisk" style="color: red; display: none;">*</span></label>
						</th>
						<td>
							<select id="user" name="user[]" multiple="multiple" class="regular-text" size="5" style="min-height: 120px;">
								<?php
								$users_list_available = false;
								if($users_list = didar_api::get_user_list()){
									if(is_array($users_list) && count($users_list) > 0){
										$users_list_available = true;
										$selected_users = isset($opt['user']) ? $opt['user'] : [];
										if(!is_array($selected_users)){
											$selected_users = !empty($selected_users) ? [$selected_users] : [];
										}
										foreach($users_list as $user){
											$is_selected = in_array($user->UserId, $selected_users);
											echo "<option value='".esc_attr($user->UserId)."' ".selected($is_selected, true, false).">".esc_html($user->DisplayName)."</option>";
										}
									}
								}
								if(!$users_list_available){
									echo "<option value=''>ابتدا کد API دیدار را وارد کنید</option>";
								}
								?>
							</select>
							<p class="description">
								<strong id="user_description_text">کاربر مسئول معاملات را انتخاب کنید<span id="user_required_text" style="display: none;"> (اجباری)</span></strong><br>
								می‌توانید چند کاربر را انتخاب کنید (برای انتخاب چندگانه از <strong>Ctrl+Click</strong> در ویندوز یا <strong>Cmd+Click</strong> در مک استفاده کنید). در صورت انتخاب چند کاربر، مسئول معامله به صورت <strong>رندم (Random)</strong> از بین کاربران انتخاب شده تعیین می‌شود.
							</p>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="product_category">انتخاب گروه محصول</label>
						</th>
						<td>
							<select id="product_category" name="product_category" class="regular-text">
								<option value="">انتخاب گروه محصول...</option>
								<?php
								if($categories = didar_api::get_category()){
									$selected = isset($opt['product_category'])?$opt['product_category']:'';
									foreach($categories as $category){
										echo "<option value='".esc_attr($category->Id)."' ".selected($selected, $category->Id, false).">".esc_html($category->Title)."</option>";
									}
								}
								?>
							</select>
							<p class="description">گروه محصول پیش‌فرض برای محصولات جدید</p>
						</td>
					</tr>
				</table>
			</div>
			
			<div class="didar-settings-section">
				<h3 class="didar-section-title">وضعیت ارسال دوره‌ای</h3>
				<table class="form-table" role="presentation">
					<tr>
						<th scope="row">وضعیت Cron</th>
						<td>
							<?php if($type == 1): ?>
								<?php if($cron_is_scheduled): ?>
									<p style="color: green; font-weight: bold;">✓ فعال</p>
									<p class="description">
										<strong>اجرای بعدی:</strong> 
										<?php 
										if($cron_next_run){
											$next_run_date = date_i18n('Y/m/d H:i:s', $cron_next_run);
											$next_run_relative = human_time_diff($cron_next_run, time());
											echo esc_html($next_run_date) . ' (' . $next_run_relative . ' دیگر)';
										} else {
											echo 'نامشخص';
										}
										?>
									</p>
									<?php if($cron_last_run): ?>
										<p class="description">
											<strong>آخرین اجرا:</strong> 
											<?php 
											$last_run_date = date_i18n('Y/m/d H:i:s', $cron_last_run['start_time']);
											$last_run_relative = human_time_diff($cron_last_run['start_time'], time());
											echo esc_html($last_run_date) . ' (' . $last_run_relative . ' پیش)';
											?>
										</p>
										<p class="description">
											<strong>وضعیت:</strong> 
											<?php 
											$status_labels = [
												'completed' => '<span style="color: green;">✓ موفق</span>',
												'running' => '<span style="color: orange;">در حال اجرا...</span>',
												'error' => '<span style="color: red;">✗ خطا</span>',
												'skipped' => '<span style="color: gray;">رد شده</span>'
											];
											echo isset($status_labels[$cron_last_run['status']]) ? $status_labels[$cron_last_run['status']] : $cron_last_run['status'];
											?>
										</p>
										<?php if(isset($cron_last_run['orders_processed']) && $cron_last_run['orders_processed'] > 0): ?>
											<p class="description">
												<strong>آمار:</strong> 
												<?php echo intval($cron_last_run['orders_processed']); ?> سفارش پردازش شده، 
												<?php echo intval($cron_last_run['orders_success']); ?> موفق، 
												<?php echo intval($cron_last_run['orders_failed']); ?> ناموفق
												<?php if(isset($cron_last_run['duration'])): ?>
													(زمان اجرا: <?php echo intval($cron_last_run['duration']); ?> ثانیه)
												<?php endif; ?>
											</p>
										<?php endif; ?>
										<?php if(!empty($cron_last_run['error'])): ?>
											<p class="description" style="color: red;">
												<strong>خطا:</strong> <?php echo esc_html($cron_last_run['error']); ?>
											</p>
										<?php endif; ?>
									<?php else: ?>
										<p class="description" style="color: orange;">هنوز اجرا نشده است</p>
									<?php endif; ?>
									<?php if($type == 1): ?>
										<form method="POST" style="margin-top: 15px;">
											<?php wp_nonce_field('didar_test_cron'); ?>
											<input type="submit" name="test_cron" value="اجرای دستی Cron" class="button button-secondary" onclick="return confirm('آیا می‌خواهید cron را به صورت دستی اجرا کنید؟');" />
											<p class="description" style="margin-top: 5px;">با کلیک روی این دکمه، cron به صورت دستی اجرا می‌شود و می‌توانید نتیجه را مشاهده کنید.</p>
										</form>
									<?php endif; ?>
								<?php else: ?>
									<p style="color: red; font-weight: bold;">✗ غیرفعال</p>
									<p class="description">Cron job تنظیم نشده است. لطفا تنظیمات را ذخیره کنید.</p>
								<?php endif; ?>
							<?php else: ?>
								<p class="description">ارسال دوره‌ای فعال نیست. برای فعال‌سازی، نوع ارسال را روی "دوره‌ای" تنظیم کنید.</p>
							<?php endif; ?>
						</td>
					</tr>
				</table>
			</div>
			
			<div class="didar-settings-section">
				<h3 class="didar-section-title">تنظیمات پیشرفته</h3>
				<table class="form-table" role="presentation">
					<tr>
						<th scope="row">گزینه‌های نمایش</th>
						<td>
							<fieldset>
								<label>
									<input type="checkbox" name="soid" <?php checked( $soid, "on" ); ?>/>
									<span>نمایش شماره سفارش ووکامرس در نام سفارش در دیدار</span>
								</label>
							</fieldset>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="order_count">تعداد ارسال از وبسرویس</label>
						</th>
						<td>
							<input type="number" id="order_count" name="order_count" value="<?php echo isset($opt['order_count'])?esc_attr($opt['order_count']):20; ?>" class="small-text" min="1" />
							<p class="description">در هر بار ارسال وبسرویس چه تعداد فاکتور ارسال شود</p>
						</td>
					</tr>
					<tr>
						<th scope="row">
							<label for="order_start">شروع ارسال از فاکتور</label>
						</th>
						<td>
							<input type="number" id="order_start" name="order_start" value="<?php echo isset($opt['order_start'])?esc_attr($opt['order_start']):0; ?>" class="small-text" min="0" />
							<p class="description">شروع ارسال فاکتور از فاکتور با ایدی مشخص شده</p>
						</td>
					</tr>
				</table>
			</div>
			
			<p class="submit">
				<input type="submit" name="save" value="ذخیره تنظیمات" class="button button-primary button-large"/>
			</p>
		</div>
	</form>
</div>

<style>
/* RTL Support */
.didar-settings-wrapper,
.didar-settings-wrapper * {
	direction: rtl;
	text-align: right;
}

.didar-settings-wrapper input[dir="ltr"],
.didar-settings-wrapper code,
.didar-settings-wrapper pre {
	direction: ltr;
	text-align: left;
}

.didar-settings-wrapper {
	max-width: 1200px;
	margin: 20px 0;
}

.didar-settings-header {
	background: #fff;
	padding: 20px;
	border: 1px solid #ccd0d4;
	border-radius: 4px;
	margin-bottom: 20px;
	box-shadow: 0 1px 1px rgba(0,0,0,.04);
}

.didar-settings-header h2 {
	margin: 0 0 5px 0;
	font-size: 23px;
	font-weight: 400;
}

.didar-settings-header .description {
	margin: 0;
	color: #646970;
}

.didar-settings-section {
	background: #fff;
	padding: 20px;
	border: 1px solid #ccd0d4;
	border-radius: 4px;
	margin-bottom: 20px;
	box-shadow: 0 1px 1px rgba(0,0,0,.04);
}

.didar-section-title {
	margin: 0 0 15px 0;
	padding-bottom: 10px;
	border-bottom: 2px solid #2271b1;
	font-size: 16px;
	font-weight: 600;
	color: #1d2327;
}

.didar-settings-section .form-table {
	margin-top: 0;
}

.didar-settings-section .form-table th {
	padding: 15px 0 15px 10px;
	width: 200px;
	font-weight: 600;
	text-align: right;
}

.didar-settings-section .form-table td {
	padding: 15px 10px;
	text-align: right;
}

.didar-settings-section .form-table fieldset label {
	display: block;
	margin-bottom: 8px;
	margin-right: 0;
}

.didar-settings-section .form-table fieldset input[type="radio"] {
	margin-left: 5px;
	margin-right: 0;
}

.didar-settings-section .form-table fieldset .description {
	margin-right: 25px;
	margin-left: 0;
	margin-top: 5px;
}

.didar-status-table-wrapper {
	background: #f9f9f9;
	padding: 15px;
	border-radius: 4px;
	border: 1px solid #ddd;
}

.didar-status-table {
	margin: 0;
	background: #fff;
	width: 100%;
}

.didar-status-table thead th {
	background: #f6f7f7;
	font-weight: 600;
	padding: 12px;
	border-bottom: 2px solid #2271b1;
	text-align: right;
}

.didar-status-table tbody td {
	padding: 10px 12px;
	border-bottom: 1px solid #ddd;
	text-align: right;
}

.didar-status-table tbody tr:hover {
	background: #f9f9f9;
}

.didar-status-table tbody tr:last-child td {
	border-bottom: none;
}

.didar-settings-section input[type="text"],
.didar-settings-section input[type="number"],
.didar-settings-section select {
	padding: 6px 8px;
}

.didar-settings-section .description {
	color: #646970;
	font-style: normal;
	margin-top: 5px;
	text-align: right;
}

.didar-settings-section .description strong {
	color: #1d2327;
}

.submit {
	margin-top: 20px;
	padding-top: 20px;
	border-top: 1px solid #ddd;
	text-align: right;
}

.submit .button-primary {
	font-size: 14px;
	height: auto;
	padding: 8px 20px;
}
</style>

<script>
	<?php 
	$kariz = didar_api::get_kariz_list();
	// Ensure kariz is always an array to prevent JavaScript errors
	if(!is_array($kariz)){
		error_log("خطا در دریافت لیست کاریزها: مقدار برگشتی آرایه نیست - " . gettype($kariz));
		$kariz = [];
	}
	// Log if kariz is empty
	if(empty($kariz)){
		error_log("هشدار: لیست کاریزها خالی است. ممکن است API خطا داده باشد یا هیچ کاریزی وجود نداشته باشد.");
	}
	?>
	var kariz = <?php echo json_encode($kariz,JSON_UNESCAPED_UNICODE); ?>;
	(function($) {
		var parentSelect        = $("#parentSelect");
		var childSelect         = $("#childSelect");
		var selectedParentValue = "<?php echo isset($opt['parent_kariz']) ? esc_js($opt['parent_kariz']) : ''; ?>";
		var selectedChildValue  = "<?php echo isset($opt['kariz']) ? esc_js($opt['kariz']) : ''; ?>";

		// Check if kariz is valid array
		if(!Array.isArray(kariz)){
			console.error('خطا: لیست کاریزها نامعتبر است');
			kariz = [];
		}

		if(kariz.length === 0){
			console.warn('هشدار: لیست کاریزها خالی است. لطفا لاگ خطاها را بررسی کنید.');
		}

		kariz.forEach(function (item) {
			if(item && item.Title && item.Id){
				var option = $("<option>").text(item.Title).val(item.Id);
				parentSelect.append(option);
			}
		});

		parentSelect.on("change", function () {
			var selectedParentId = parentSelect.val();
			childSelect.empty();
			var selectedParent = kariz.find(function (item) {
				return item && item.Id === selectedParentId;
			});

			if (selectedParent && selectedParent.Stages && Array.isArray(selectedParent.Stages)) {
				selectedParent.Stages.forEach(function (stage) {
					if(stage && stage.Title && stage.Id){
						var option = $("<option>").text(stage.Title).val(stage.Id);
						childSelect.append(option);
					}
				});
			}
		});

		if(selectedParentValue){
			parentSelect.val(selectedParentValue).trigger("change");
		}
		if(selectedChildValue){
			childSelect.val(selectedChildValue);
		}

	})(jQuery);
	
	// Handle status enable/disable and deal type selection
	jQuery(document).ready(function($) {
		// Enable/disable deal type select based on checkbox
		$('.status-enable-checkbox').on('change', function() {
			var row = $(this).closest('tr');
			var select = row.find('.status-deal-type-select');
			
			if($(this).is(':checked')) {
				select.prop('disabled', false);
			} else {
				select.prop('disabled', true);
			}
		});
		
		// Initialize on page load
		$('.status-enable-checkbox').trigger('change');
		
		// Handle send type change - show/hide cron interval dropdown
		function toggleCronInterval() {
			if($('#send_type_1').is(':checked')) {
				$('#cron_interval_row').show();
			} else {
				$('#cron_interval_row').hide();
			}
		}
		
		$('input[name="send_type"]').on('change', toggleCronInterval);
		toggleCronInterval();
		
		// Function to check if user select has valid options (not just placeholder)
		function hasUserOptions() {
			var userSelect = $('#user');
			var options = userSelect.find('option');
			// Check if there are options with actual values (not just placeholder)
			var hasValidOptions = false;
			options.each(function() {
				var val = $(this).val();
				if(val && val !== '' && val !== '0'){
					hasValidOptions = true;
					return false; // break loop
				}
			});
			return hasValidOptions;
		}
		
		// Function to update required state of user field
		function updateUserRequiredState() {
			var userSelect = $('#user');
			var hasOptions = hasUserOptions();
			
			if(hasOptions){
				// Field has options, make it required and show asterisk
				userSelect.prop('required', true);
				$('#user_required_asterisk').show();
				$('#user_required_text').show();
			} else {
				// Field has no options, remove required and hide asterisk
				userSelect.prop('required', false);
				$('#user_required_asterisk').hide();
				$('#user_required_text').hide();
			}
		}
		
		// Update required state when user selection changes
		$('#user').on('change', function() {
			updateUserRequiredState();
		});
		
		// Update required state when API code changes (for future dynamic loading)
		$('#didar_api').on('blur', function() {
			// This could trigger a reload of users list if needed
			updateUserRequiredState();
		});
		
		// Initialize required state on page load
		updateUserRequiredState();
		
		// Validate user selection on form submit
		$('form').on('submit', function(e) {
			var userSelect = $('#user');
			var selectedUsers = userSelect.val();
			var hasOptions = hasUserOptions();
			
			// Only validate if field has options and is required
			if(hasOptions && (!selectedUsers || selectedUsers.length === 0)){
				e.preventDefault();
				alert('خطا: تعیین مسئول معامله اجباری است. لطفا حداقل یک کاربر را انتخاب کنید.');
				userSelect.focus();
				return false;
			}
		});
	});
</script>