<div class="wrap">
	<h2>نمایش خطاهای دیدار</h2>
	<?php
	global $wpdb;
	$paging = '';

	// Get all errors with detailed information, sorted by newest first
	$rows = $wpdb->get_results("
		SELECT m1.post_id, m1.meta_value as error_msg, m1.meta_id
		FROM $wpdb->postmeta m1 
		WHERE m1.meta_key='didar_msg' 
		AND NOT EXISTS (
			SELECT post_id FROM $wpdb->postmeta 
			WHERE post_id=m1.post_id 
			AND meta_key='didar_id' 
			AND meta_value<>''
		)
		ORDER BY m1.meta_id DESC
	");
	
	if(!empty($rows)){
		$url = admin_url();
		$paging = paging($rows, 30);
		?>
		<form method="GET" action="">
			<?php
			// Preserve all GET parameters except paging
			foreach($_GET as $key => $value){
				if($key != 'paging' && $key != '__paging' && $key != 'page'){
					if(is_array($value)){
						foreach($value as $sub_key => $sub_value){
							echo '<input type="hidden" name="' . esc_attr($key) . '[' . esc_attr($sub_key) . ']" value="' . esc_attr($sub_value) . '" />';
						}
					} else {
						echo '<input type="hidden" name="' . esc_attr($key) . '" value="' . esc_attr($value) . '" />';
					}
				}
			}
			// Preserve page parameter for WordPress admin
			if(isset($_GET['page'])){
				echo '<input type="hidden" name="page" value="' . esc_attr($_GET['page']) . '" />';
			}
			?>
		<table class="widefat striped" id="didar-error-table">
			<thead>
				<tr>
					<th style="width: 100px;">شماره سفارش</th>
					<th style="width: 120px;">منبع خطا</th>
					<th style="width: 150px;">عملیات</th>
					<th style="width: 200px;">Endpoint</th>
					<th style="width: 150px;">تابع</th>
					<th style="width: 150px;">تاریخ/زمان</th>
					<th>متن خطا</th>
					<th style="width: 120px;">عملیات</th>
				</tr>
			</thead>
			<tbody>
				<?php
				foreach($rows as $row){
					$order_id = $row->post_id;
					
					// Get all error details
					$source = get_post_meta($order_id, 'didar_error_source', true);
					$operation = get_post_meta($order_id, 'didar_error_operation', true);
					$endpoint = get_post_meta($order_id, 'didar_error_endpoint', true);
					$function = get_post_meta($order_id, 'didar_error_function', true);
					$datetime = get_post_meta($order_id, 'didar_error_datetime', true);
					$error_code = get_post_meta($order_id, 'didar_error_code', true);
					$error_message = get_post_meta($order_id, 'didar_error_message', true);
					$detail = get_post_meta($order_id, 'didar_error_detail', true);
					
					// Fallback to old data if new fields don't exist
					if(empty($source)){
						$source = 'نامشخص';
					}
					if(empty($operation)){
						$operation = get_post_meta($order_id, 'didar_error_operation', true);
						if(empty($operation)) $operation = 'نامشخص';
					}
					if(empty($endpoint)){
						$endpoint = get_post_meta($order_id, 'didar_error_endpoint', true);
						if(empty($endpoint)) $endpoint = 'نامشخص';
					}
					if(empty($function)){
						$function = 'نامشخص';
					}
					if(empty($datetime)){
						$datetime = 'نامشخص';
					}
					if(empty($error_message)){
						$error_message = $row->error_msg;
					}
					if(empty($detail)){
						$detail = get_post_meta($order_id, 'didar_error_detail', true);
						if(empty($detail)){
							$detail = $error_message;
						}
					}
					
					// Format datetime
					if($datetime != 'نامشخص'){
						$datetime_formatted = date_i18n('Y/m/d H:i:s', strtotime($datetime));
					} else {
						$datetime_formatted = 'نامشخص';
					}
					
					// Truncate long text for display
					$error_display = mb_substr($error_message, 0, 100);
					if(mb_strlen($error_message) > 100){
						$error_display .= '...';
					}
					
					$operation_display = mb_substr($operation, 0, 30);
					if(mb_strlen($operation) > 30){
						$operation_display .= '...';
					}
					
					$endpoint_display = mb_substr($endpoint, 0, 40);
					if(mb_strlen($endpoint) > 40){
						$endpoint_display .= '...';
					}
					
					// Get API payload if available (for API errors)
					$api_url = get_post_meta($order_id, 'didar_error_api_url', true);
					$api_headers = get_post_meta($order_id, 'didar_error_api_headers', true);
					$api_body = get_post_meta($order_id, 'didar_error_api_body', true);
					
					// Prepare data for modal
					$error_data = [
						'order_id' => $order_id,
						'source' => $source,
						'operation' => $operation,
						'endpoint' => $endpoint,
						'function' => $function,
						'datetime' => $datetime_formatted,
						'error_code' => $error_code,
						'error_message' => $error_message,
						'detail' => $detail,
						'api_url' => $api_url ? $api_url : '',
						'api_headers' => $api_headers ? $api_headers : '',
						'api_body' => $api_body ? $api_body : ''
					];
					
					echo "
					<tr>
						<td><a href='{$url}admin.php?page=wc-orders&action=edit&id=$order_id' target='_blank'>سفارش #$order_id</a></td>
						<td><span class='error-source error-source-".strtolower($source)."'>$source</span></td>
						<td><code style='font-size:11px;'>$operation_display</code></td>
						<td><code style='font-size:11px;'>$endpoint_display</code></td>
						<td><code style='font-size:11px;'>$function</code></td>
						<td>$datetime_formatted</td>
						<td><strong>$error_display</strong></td>
						<td>
							<button type='button' class='button button-small view-error-details' 
									data-error='".esc_attr(json_encode($error_data, JSON_UNESCAPED_UNICODE))."'>
								مشاهده جزئیات بیشتر
							</button>
						</td>
					</tr>";
				}
				?>
			</tbody>
		</table>
		<?php echo $paging; ?>
		</form>
		
		<!-- Error Details Modal -->
		<div id="didar-error-modal" style="display: none;">
			<div class="didar-modal-overlay"></div>
			<div class="didar-modal-content">
				<div class="didar-modal-header">
					<h3>جزئیات کامل خطا</h3>
					<button type="button" class="didar-modal-close">&times;</button>
				</div>
				<div class="didar-modal-body">
					<table class="form-table">
						<tr>
							<th>شماره سفارش:</th>
							<td id="modal-order-id">-</td>
						</tr>
						<tr>
							<th>منبع خطا:</th>
							<td id="modal-source">-</td>
						</tr>
						<tr>
							<th>عملیات:</th>
							<td id="modal-operation">-</td>
						</tr>
						<tr>
							<th>Endpoint:</th>
							<td id="modal-endpoint"><code>-</code></td>
						</tr>
						<tr>
							<th>تابع:</th>
							<td id="modal-function"><code>-</code></td>
						</tr>
						<tr>
							<th>تاریخ/زمان:</th>
							<td id="modal-datetime">-</td>
						</tr>
						<tr>
							<th>کد خطا:</th>
							<td id="modal-error-code">-</td>
						</tr>
						<tr>
							<th>متن خطا:</th>
							<td id="modal-error-message"><strong>-</strong></td>
						</tr>
						<tr>
							<th>جزئیات کامل:</th>
							<td id="modal-detail" style="white-space: pre-wrap; word-wrap: break-word;">-</td>
						</tr>
					</table>
					
					<!-- API Payload Section (only for API errors) -->
					<div id="modal-api-payload-section" style="display: none; margin-top: 20px; padding-top: 20px; border-top: 2px solid #ddd;">
						<h4 style="margin-top: 0;">جزئیات درخواست API به app.didar.me</h4>
						<table class="form-table">
							<tr>
								<th style="width: 150px;">URL:</th>
								<td>
									<code id="modal-api-url" style="word-break: break-all; display: block; background: #f5f5f5; padding: 8px; border-radius: 3px;">-</code>
								</td>
							</tr>
							<tr>
								<th>Headers:</th>
								<td>
									<pre id="modal-api-headers" style="background: #f5f5f5; padding: 10px; border-radius: 3px; overflow-x: auto; max-height: 200px; overflow-y: auto; font-size: 12px; white-space: pre-wrap; word-wrap: break-word;">-</pre>
								</td>
							</tr>
							<tr>
								<th>Body (Payload):</th>
								<td>
									<pre id="modal-api-body" style="background: #f5f5f5; padding: 10px; border-radius: 3px; overflow-x: auto; max-height: 400px; overflow-y: auto; font-size: 12px; white-space: pre-wrap; word-wrap: break-word;">-</pre>
								</td>
							</tr>
						</table>
					</div>
				</div>
				<div class="didar-modal-footer">
					<button type="button" class="button didar-modal-close">بستن</button>
				</div>
			</div>
		</div>
		
		<style>
		.error-source {
			padding: 4px 8px;
			border-radius: 3px;
			font-size: 11px;
			font-weight: bold;
		}
		.error-source-didar {
			background-color: #ff9800;
			color: #fff;
		}
		.error-source-wordpress {
			background-color: #2196F3;
			color: #fff;
		}
		.error-source-نامشخص {
			background-color: #9e9e9e;
			color: #fff;
		}
		
		.didar-modal-overlay {
			position: fixed;
			top: 0;
			left: 0;
			width: 100%;
			height: 100%;
			background: rgba(0, 0, 0, 0.7);
			z-index: 100000;
		}
		
		.didar-modal-content {
			position: fixed;
			top: 50%;
			left: 50%;
			transform: translate(-50%, -50%);
			background: #fff;
			border-radius: 4px;
			box-shadow: 0 4px 20px rgba(0, 0, 0, 0.3);
			z-index: 100001;
			max-width: 800px;
			width: 90%;
			max-height: 90vh;
			display: flex;
			flex-direction: column;
		}
		
		.didar-modal-header {
			padding: 15px 20px;
			border-bottom: 1px solid #ddd;
			display: flex;
			justify-content: space-between;
			align-items: center;
		}
		
		.didar-modal-header h3 {
			margin: 0;
		}
		
		.didar-modal-close {
			background: none;
			border: none;
			font-size: 24px;
			cursor: pointer;
			color: #666;
			padding: 0;
			width: 30px;
			height: 30px;
			line-height: 30px;
		}
		
		.didar-modal-close:hover {
			color: #000;
		}
		
		.didar-modal-body {
			padding: 20px;
			overflow-y: auto;
			flex: 1;
		}
		
		.didar-modal-body .form-table th {
			width: 150px;
			vertical-align: top;
		}
		
		.didar-modal-footer {
			padding: 15px 20px;
			border-top: 1px solid #ddd;
			text-align: left;
		}
		
		#didar-error-table {
			margin-top: 20px;
		}
		
		#didar-error-table th {
			background-color: #f1f1f1;
		}
		</style>
		
		<script>
		jQuery(document).ready(function($) {
			// Helper function to format JSON
			function formatJSON(str) {
				if(!str) return '-';
				try {
					var obj = JSON.parse(str);
					return JSON.stringify(obj, null, 2);
				} catch(e) {
					return str;
				}
			}
			
			$('.view-error-details').on('click', function() {
				var errorData = $(this).data('error');
				if(!errorData) {
					alert('خطا در بارگذاری اطلاعات');
					return;
				}
				
				// Populate modal
				$('#modal-order-id').html('<a href="<?php echo admin_url(); ?>admin.php?page=wc-orders&action=edit&id=' + errorData.order_id + '" target="_blank">سفارش #' + errorData.order_id + '</a>');
				$('#modal-source').html('<span class="error-source error-source-' + errorData.source.toLowerCase() + '">' + errorData.source + '</span>');
				$('#modal-operation').text(errorData.operation || '-');
				$('#modal-endpoint').html('<code>' + (errorData.endpoint || '-') + '</code>');
				$('#modal-function').html('<code>' + (errorData.function || '-') + '</code>');
				$('#modal-datetime').text(errorData.datetime || '-');
				$('#modal-error-code').text(errorData.error_code || '-');
				$('#modal-error-message').html('<strong>' + (errorData.error_message || '-') + '</strong>');
				$('#modal-detail').text(errorData.detail || '-');
				
				// Show/hide API payload section based on availability
				if(errorData.api_url || errorData.api_headers || errorData.api_body) {
					$('#modal-api-payload-section').show();
					$('#modal-api-url').text(errorData.api_url || '-');
					
					// Format headers
					if(errorData.api_headers) {
						var headersFormatted = formatJSON(errorData.api_headers);
						$('#modal-api-headers').text(headersFormatted);
					} else {
						$('#modal-api-headers').text('-');
					}
					
					// Format body (try to format as JSON if possible)
					if(errorData.api_body) {
						var bodyFormatted = formatJSON(errorData.api_body);
						$('#modal-api-body').text(bodyFormatted);
					} else {
						$('#modal-api-body').text('-');
					}
				} else {
					$('#modal-api-payload-section').hide();
				}
				
				// Show modal
				$('#didar-error-modal').fadeIn(200);
			});
			
			$('.didar-modal-close, .didar-modal-overlay').on('click', function() {
				$('#didar-error-modal').fadeOut(200);
			});
			
			// Close on ESC key
			$(document).on('keydown', function(e) {
				if(e.keyCode === 27) {
					$('#didar-error-modal').fadeOut(200);
				}
			});
		});
		</script>
		<?php
	} else {
		echo '<p>هیچ خطایی یافت نشد.</p>';
	}
	?>
</div>
