<?php
/**
 * Plugin Name: Didar CRM WooCommerce Integration
 * Plugin URI: https://didar.com
 * Description: پلاگین یکپارچه‌سازی ووکامرس با سیستم CRM دیدار - ارسال خودکار سفارش‌ها و همگام‌سازی داده‌ها
 * Version: 2.0.3
 * Author: Didar Team
 * Author URI: https://didar.com
 * Text Domain: didar-crm-woocommerce
 * Domain Path: /languages
 * Requires at least: 5.0
 * Requires PHP: 7.4
 * License: GPL v2 or later
 * License URI: https://www.gnu.org/licenses/gpl-2.0.html
 */

use Automattic\WooCommerce\Utilities\OrderUtil;

function isHPOSenabled(){
	if (OrderUtil::custom_orders_table_usage_is_enabled()) {
		return true;
	} else {
		return false;
	}
}

if(!defined('ds'))
	define('ds',DIRECTORY_SEPARATOR);
define('did_path',dirname(__file__).ds);

include_once(did_path.'inc'.ds.'helper.php');
include_once(did_path.'inc'.ds.'hooks.php');
include_once(did_path.'inc'.ds.'didar_api.php');
include_once(did_path.'inc'.ds.'paging.php');

// Declare WooCommerce compatibility
add_action('before_woocommerce_init', function() {
	if (class_exists('\Automattic\WooCommerce\Utilities\FeaturesUtil')) {
		\Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility('custom_order_tables', __FILE__, true);
	}
});

new did_hooks();


function did_enqueue_admin_css_for_wc_orders() {
	//$screen = get_current_screen();
	//if ($screen && $screen->id === 'woocommerce_page_wc-orders') {
	wp_enqueue_style('didar-admin-css', plugins_url( 'assets/css/admin.css', __FILE__ ) );
	//}
}
add_action('admin_enqueue_scripts', 'did_enqueue_admin_css_for_wc_orders');

add_action( 'admin_enqueue_scripts', 'did_plugin_enqueue_scripts' );
function did_plugin_enqueue_scripts() {
	wp_enqueue_style( 'did-plugin-style', plugins_url( 'css/style.css', __FILE__ ), array(), '1.0' );
	$inline_css = "
#toplevel_page_did_managment img {
    width: 20px;
    height: auto;
}
    ";
	wp_add_inline_style( 'did-plugin-style', $inline_css );
}

add_action( 'add_meta_boxes', 'did_custom_order_meta_box' );
/**
 * Add custom meta box.
 *
 * @return void
 */
function did_custom_order_meta_box() {

	add_meta_box(
		'custom-order-meta-box',
		'دیدار',
		'did_custom_order_meta_box_callback',
		wc_get_page_screen_id( 'shop-order' ),
		'side',
		'core'
	);
}

function did_custom_order_meta_box_callback( $post ){
	$order = wc_get_order($post->ID);
	$opt = get_option( 'did_option', [] );
	$order_status_key = 'wc-' . $order->get_status();
	// Check if status is enabled in status_config or old status array
	$status_enabled = false;
	if(isset($opt['status_config']) && isset($opt['status_config'][$order_status_key])){
		$status_enabled = true;
	} elseif(isset($opt['status']) && in_array($order_status_key, $opt['status'])){
		$status_enabled = true;
	}
?>
<div class="order_data_column">
	<?php if($status_enabled){ ?>
	<div class="didar_status">
		<?php
		if($code=get_post_meta($order->get_id(),'didar_id',true))
			echo "<span class='sent'>ارسال شده</span>
			<div>کد ثبت شده:<kbd class='dcode'>".get_post_meta($order->get_id(),'didar_id',true)."</kbd></div>";
		else
			echo "<span class='waiting'>ارسال نشده</span>";
		?>
	</div>
	<div class="save_order_didar_wrapper">
		<input type="checkbox" name="didar" value="1"/> <label>ارسال به دیدار</label>
	</div>
	<?php
	}else 
		echo 'فاکتور جاری اماده برای ارسال نمیباشد.';
	?>
</div>
<?php
}

add_action('woocommerce_process_shop_order_meta', 'did_save_admin_order', 10, 2);
function did_save_admin_order($order_id, $order){

	if(!is_admin() or !isset($_POST['didar']))
		return;
	$didar = didar_api::save_order($order_id);

	if(isset($didar->Message) or isset($didar->Error)){
		didar_api::log_error($order_id, $didar, 'did_save_admin_order', 'WordPress');
	} else {
		update_post_meta($order_id,'didar_id',$didar->Id);
	}

}
/*function custom_order_meta_box_callback( $order ) {
?>
		<div class="order_data_column">
			<div class="didar_status">
			<?php
			if($order->get_status()!='completed')
				echo 'فقط فاکتورهای تکمیل شده قابل ارسال میباشند';
			else{
				if($code=get_post_meta($order->get_id(),'didar_id',true)){
					echo "<span class='sent'>ارسال شده</span>
					<p style='margin-bottom: 5px;''>کد ثبت شده:</p>
					<code class='dcode'>$code</code>
					";

				$btn = isset($code)?'ثبت دوباره':'ثبت فاکتور در دیدار';
?>
				<div class="save_order_didar_wrapper"><input type="button" value="<?php echo $btn ?>" class="button-primary save_order_didar"></div>
				<script>
				jQuery('.save_order_didar').click(function(){
					jQuery('.save_order_didar_wrapper').addClass('wait');
					jQuery('.msg').hide();
					jQuery.ajax({
						url:ajaxurl,
						type:'POST',
						data:{
							action:'didar_send_order',
							oid:<?php echo $order->get_id(); ?>
						},
					}).done(function(data) {
						jQuery('.msg').text(data[1]).show();
						jQuery('.save_order_didar_wrapper').removeClass('wait');
					});
				});
				</script>
				<?php
				}else{
					echo "<span class=''>ارسال نشده</span>";
				}
			}
?>
			</div>
			<span class="msg notice" class="respond" style="display:none"></span>
</div>
<?php
}*/

function did_get_sku($pid) {
	return get_post_meta( $pid, "_sku", true);

	/*$product = wc_get_product($variation_id);

    if ($product && $product->is_type('variation')) {
        $parent_id = $product->get_parent_id();
        $parent_product = wc_get_product($parent_id);

        if ($parent_product) {
            $variations = $parent_product->get_available_variations();

            foreach ($variations as $variation) {
                if ($variation['variation_id'] === $variation_id) {
                    return $variation['sku'];
                }
            }
        }
    }

    return '';*/
}


function did_get_variation_id_by_sku($sku) {
	global $wpdb;

	$variation_id = $wpdb->get_var(
		$wpdb->prepare(
			"SELECT p.ID
            FROM {$wpdb->prefix}posts p
            INNER JOIN {$wpdb->prefix}postmeta pm ON p.ID = pm.post_id
            WHERE p.post_type = 'product_variation'
            AND p.post_status = 'publish'
            AND pm.meta_key = '_sku'
            AND pm.meta_value = %s",
			$sku
		)
	);

	return $variation_id;
}


/**
* Helper function to convert interval string to seconds
*/
function didar_get_interval_seconds($interval) {
	switch($interval) {
		case '1min': return 60;
		case '5min': return 300;
		case '10min': return 600;
		case '30min': return 1800;
		case '1hour': return 3600;
		case '5hour': return 18000;
		default: return 300; // Default 5 minutes
	}
}

/**
* Helper function to get interval name for WP Cron
*/
function didar_get_cron_schedule_name($interval) {
	return 'didar_cron_' . $interval;
}

/**
* Add custom cron schedules
*/
add_filter('cron_schedules', 'didar_add_cron_schedules');
function didar_add_cron_schedules($schedules) {
	$intervals = [
		'1min' => 60,
		'5min' => 300,
		'10min' => 600,
		'30min' => 1800,
		'1hour' => 3600,
		'5hour' => 18000
	];
	
	foreach($intervals as $name => $seconds) {
		$schedules['didar_cron_' . $name] = [
			'interval' => $seconds,
			'display' => didar_get_interval_display($name)
		];
	}
	
	return $schedules;
}

function didar_get_interval_display($interval) {
	$names = [
		'1min' => 'هر 1 دقیقه',
		'5min' => 'هر 5 دقیقه',
		'10min' => 'هر 10 دقیقه',
		'30min' => 'هر 30 دقیقه',
		'1hour' => 'هر 1 ساعت',
		'5hour' => 'هر 5 ساعت'
	];
	return isset($names[$interval]) ? $names[$interval] : $interval;
}

/**
* schedular task
*/
// Schedule the function to run based on interval
add_action('didar_send_all_order_cron', 'didar_send_all_order_function');
function didar_send_all_order_function() {
	global $wpdb;
	$opt = get_option( 'did_option', [] );
	
	// Log cron execution start
	$cron_start_time = time();
	$cron_log = [
		'start_time' => $cron_start_time,
		'status' => 'running',
		'orders_processed' => 0,
		'orders_success' => 0,
		'orders_failed' => 0,
		'error' => null
	];
	
	try {
		// Only run for periodic mode (send_type == 1)
		if( $opt['send_type'] == 1){
			$from = isset($opt['order_start'])?$opt['order_start']:0;
			$to   = isset($opt['order_count'])?$opt['order_count']:20;
			$status = empty($opt['status']) ? [] : $opt['status'];
			
			if(empty($status)){
				$cron_log['error'] = 'هیچ وضعیتی برای ارسال انتخاب نشده است';
				$cron_log['status'] = 'error';
			} else {
				$status_str = implode("','",$status);

				if( isHPOSenabled() ){
					$rows = $wpdb->get_results("
						select * from {$wpdb->prefix}wc_orders o 
						where o.type='shop_order' and o.status in('$status_str') 
						and o.id> $from and NOT EXISTS(select post_id from $wpdb->postmeta where post_id=o.id and meta_key='didar_id' and meta_value<>'') 
						order by id limit $to", ARRAY_A);

					if(!empty($rows)){
						foreach($rows as $row){
							$cron_log['orders_processed']++;
							$didar = didar_api::save_order($row['id']);
							if(isset($didar->Message)or isset($didar->Error)){
								$cron_log['orders_failed']++;
								didar_api::log_error($row['id'], $didar, 'didar_send_all_order_function', 'WordPress');
							} else {
								$cron_log['orders_success']++;
							}
							if(isset($didar->Id)){
								update_post_meta($row['id'],'didar_id',$didar->Id);
							}
						}
					}
				}else{
					$rows = $wpdb->get_results("
						select * from {$wpdb->prefix}posts o 
						where o.post_type='shop_order' and o.post_status in('$status_str') 
						and o.ID> $from and NOT EXISTS(select post_id from $wpdb->postmeta where post_id=o.ID and meta_key='didar_id' and meta_value<>'') 
						order by ID limit $to", ARRAY_A);

					if(!empty($rows)){
						foreach($rows as $row){
							$cron_log['orders_processed']++;
							$didar = didar_api::save_order($row['ID']);
							if(isset($didar->Message)or isset($didar->Error)){
								$cron_log['orders_failed']++;
								didar_api::log_error($row['ID'], $didar, 'didar_send_all_order_function', 'WordPress');
							} else {
								$cron_log['orders_success']++;
							}
							if(isset($didar->Id)){
								update_post_meta($row['ID'],'didar_id',$didar->Id);
							}
						}
					}
				}
			}
		} else {
			$cron_log['error'] = 'حالت ارسال دوره‌ای فعال نیست (send_type != 1)';
			$cron_log['status'] = 'skipped';
		}
	} catch (Exception $e) {
		$cron_log['error'] = $e->getMessage();
		$cron_log['status'] = 'error';
	}
	
	// Mark as completed
	$cron_log['end_time'] = time();
	$cron_log['duration'] = $cron_log['end_time'] - $cron_log['start_time'];
	if($cron_log['status'] == 'running'){
		$cron_log['status'] = 'completed';
	}
	
	// Save cron log
	update_option('didar_cron_last_run', $cron_log);
}

/**
* Retry failed orders (for instant send mode)
* Only retries orders that failed during instant send mode
*/
add_action('didar_retry_failed_orders_cron', 'didar_retry_failed_orders');
function didar_retry_failed_orders() {
	global $wpdb;
	$opt = get_option( 'did_option', [] );
	
	// Only retry if instant send mode is enabled
	if( $opt['send_type'] != 3 ){
		return;
	}
	
	$status = implode("','",$opt['status']);
	
	// Get orders that have error from instant send mode but no success (didar_id)
	if( isHPOSenabled() ){
		$rows = $wpdb->get_results("
			select o.id as order_id from {$wpdb->prefix}wc_orders o 
			where o.type='shop_order' and o.status in('$status') 
			and EXISTS(select post_id from $wpdb->postmeta where post_id=o.id and meta_key='didar_msg') 
			and EXISTS(select post_id from $wpdb->postmeta where post_id=o.id and meta_key='didar_instant_send_error' and meta_value='1') 
			and NOT EXISTS(select post_id from $wpdb->postmeta where post_id=o.id and meta_key='didar_id' and meta_value<>'') 
			limit 20", ARRAY_A);
	} else {
		$rows = $wpdb->get_results("
			select o.ID as order_id from {$wpdb->prefix}posts o 
			where o.post_type='shop_order' and o.post_status in('$status') 
			and EXISTS(select post_id from $wpdb->postmeta where post_id=o.ID and meta_key='didar_msg') 
			and EXISTS(select post_id from $wpdb->postmeta where post_id=o.ID and meta_key='didar_instant_send_error' and meta_value='1') 
			and NOT EXISTS(select post_id from $wpdb->postmeta where post_id=o.ID and meta_key='didar_id' and meta_value<>'') 
			limit 20", ARRAY_A);
	}
	
	if(!empty($rows)){
		foreach($rows as $row){
			$order_id = isHPOSenabled() ? $row['id'] : $row['order_id'];
			$didar = didar_api::save_order($order_id);
			if(isset($didar->Message)or isset($didar->Error)){
				didar_api::log_error($order_id, $didar, 'didar_retry_failed_orders', 'WordPress');
			}
			if(isset($didar->Id)){
				update_post_meta($order_id,'didar_id',$didar->Id);
				// Remove error message and instant send error flag on success
				delete_post_meta($order_id, 'didar_msg');
				delete_post_meta($order_id, 'didar_instant_send_error');
			}
		}
	}
}

/**
* Hook for order status change - instant send mode
*/
add_action('woocommerce_order_status_changed', 'didar_send_order_on_status_change', 10, 4);
function didar_send_order_on_status_change($order_id, $old_status, $new_status, $order) {
	$opt = get_option( 'did_option', [] );
	
	// Only process if instant send mode is enabled
	if( $opt['send_type'] != 3 ){
		return;
	}
	
	// Check if this status is enabled for sending
	$status_key = 'wc-' . $new_status;
	$status_config = isset($opt['status_config']) ? $opt['status_config'] : [];
	$status_enabled = false;
	
	if(isset($status_config[$status_key])){
		$status_enabled = true;
	} elseif(isset($opt['status']) && in_array($status_key, $opt['status'])){
		$status_enabled = true;
	}
	
	// Only send if status is enabled and order hasn't been sent yet
	if($status_enabled){
		$didar_id = get_post_meta($order_id, 'didar_id', true);
		if(empty($didar_id)){
			$didar = didar_api::save_order($order_id);
			if(isset($didar->Message)or isset($didar->Error)){
				didar_api::log_error($order_id, $didar, 'didar_send_order_on_status_change', 'WordPress');
				// Mark this error as from instant send mode for retry
				update_post_meta($order_id, 'didar_instant_send_error', '1');
			}
			if(isset($didar->Id)){
				update_post_meta($order_id,'didar_id',$didar->Id);
				// Remove instant send error flag on success
				delete_post_meta($order_id, 'didar_instant_send_error');
			}
		}
	}
}



/**
* Schedule or reschedule cron based on settings
*/
function didar_schedule_cron() {
	// Clear existing crons first
	$next_scheduled = wp_next_scheduled('didar_send_all_order_cron');
	if($next_scheduled !== false){
		wp_unschedule_event($next_scheduled, 'didar_send_all_order_cron');
	}
	wp_clear_scheduled_hook('didar_send_all_order_cron');
	
	$next_scheduled_retry = wp_next_scheduled('didar_retry_failed_orders_cron');
	if($next_scheduled_retry !== false){
		wp_unschedule_event($next_scheduled_retry, 'didar_retry_failed_orders_cron');
	}
	wp_clear_scheduled_hook('didar_retry_failed_orders_cron');
	
	$opt = get_option( 'did_option', [] );
	
	// Schedule periodic cron if periodic mode is enabled
	if(isset($opt['send_type']) && $opt['send_type'] == 1){
		$interval = isset($opt['cron_interval']) ? $opt['cron_interval'] : '5min';
		$schedule_name = didar_get_cron_schedule_name($interval);
		
		// Verify that the schedule exists
		$schedules = wp_get_schedules();
		if(isset($schedules[$schedule_name])){
			// Schedule the cron
			$result = wp_schedule_event(time(), $schedule_name, 'didar_send_all_order_cron');
			if($result === false){
				error_log('Didar CRM: Failed to schedule cron job. Schedule name: ' . $schedule_name);
			}
		} else {
			error_log('Didar CRM: Invalid schedule name: ' . $schedule_name . '. Available schedules: ' . implode(', ', array_keys($schedules)));
		}
	}
	
	// Schedule retry cron if instant send mode is enabled (every 5 minutes)
	if(isset($opt['send_type']) && $opt['send_type'] == 3){
		$schedules = wp_get_schedules();
		if(isset($schedules['didar_cron_5min'])){
			$result = wp_schedule_event(time(), 'didar_cron_5min', 'didar_retry_failed_orders_cron');
			if($result === false){
				error_log('Didar CRM: Failed to schedule retry cron job.');
			}
		}
	}
}

// Schedule the cron event on plugin activation
register_activation_hook(__FILE__, 'didar_send_all_order_schedule_cron');
function didar_send_all_order_schedule_cron() {
	didar_schedule_cron();
}

// Remove the cron event on plugin deactivation
register_deactivation_hook(__FILE__, 'didar_send_all_order_remove_cron');
function didar_send_all_order_remove_cron() {
	wp_clear_scheduled_hook('didar_send_all_order_cron');
	wp_clear_scheduled_hook('didar_retry_failed_orders_cron');
}

// Reschedule cron when settings are saved
add_action('update_option_did_option', 'didar_reschedule_cron_on_settings_save', 10, 2);
function didar_reschedule_cron_on_settings_save($old_value, $new_value) {
	didar_schedule_cron();
}
