<?php
class did_hooks{
	public function __construct(){
		/**
		 * admin menu
		 */
		add_action('admin_menu',[$this,'admin_menu']);
		/**
		 * add didar column to woocomerce order table
		 */
		add_filter( 'manage_woocommerce_page_wc-orders_columns', [$this,'add_custom_shop_order_column'] );
		add_action( 'manage_woocommerce_page_wc-orders_custom_column', [$this,'shop_order_column_meta_field_value'], 10, 2);

		add_filter( 'manage_edit-shop_order_columns', [$this,'add_custom_shop_order_column'] );
		add_action( 'manage_shop_order_posts_custom_column', [$this,'shop_order_column_meta_field_value'], 10, 2);

		/**
		 * ajax hook save order to didar
		 */
		add_action('wp_ajax_didar_send_order',[$this,'didar_send_order']);
		add_action('wp_ajax_didar_send_all_order',[$this,'didar_send_all_order']);
		add_action('admin_footer', [$this,'didar_bulk_action_mark']);

	}

	function admin_menu(){
		add_menu_page( 'مدیریت دیدار'
					  , 'مدیریت دیدار'
					  , 'administrator'
					  , 'did_managment'
					  , [$this,'did_managment']
					  , plugins_url( 'assets/images/logo.png', dirname(__FILE__) )
					 );
		add_submenu_page('did_managment'
						 , 'ارسال به دیدار'
						 , 'ارسال به دیدار'
						 , 'administrator'
						 , 'did_send_ajax'
						 , [$this,'did_send_ajax']
						 , plugins_url( 'assets/images/logo.png', dirname(__FILE__) )
						);
		add_submenu_page('did_managment', 'مدیریت لاگ', 'مدیریت لاگ', 'administrator', 'did_errorlog', [$this,'did_errorlog'] );
	}


	public static function didar_hourly_send(){
		//did_hooks::didar_send_all_order();
		$opt  = get_option( 'did_option', [] );
		$from = isset($opt['order_start'])?$opt['order_start']:0;
		if(isset($opt['send_type']) and $opt['send_type']==2)
			return;

		global $wpdb;
		$status = implode("','",$opt['status']);
		$rows   = $wpdb->get_results("select id from {$wpdb->prefix}wc_orders wo where wo.status in('$status') and not exists(select post_id from $wpdb->postmeta where post_id=wo.id and meta_key='didar_id' and meta_value<>'') order by id limit $from");

		if(empty($rows))
			return;
		foreach($rows as $row){
			$didar = didar_api::save_order($row->id);
			if(isset($didar->Error)or isset($didar->Message))
				didar_api::log_error($row->id, $didar, 'didar_hourly_send', 'WordPress');
			else
				update_post_meta($row->id,'didar_id',$didar->Id);
		}
	}

	function did_managment(){
		include_once(did_path.'admin'.ds.'config.php');
	}

	function did_send_ajax(){
		include_once(did_path.'admin'.ds.'send_ajax.php');
	}

	function did_errorlog(){
		include_once(did_path.'admin'.ds.'error_log.php');
	}

	function add_custom_shop_order_column( $columns ) {

		$columns['didar_status'] = 'وضعیت دیدار';
		return $columns;
	}

	function shop_order_column_meta_field_value( $column, $order ) {
		if (is_numeric($order)) {
			$soid = $order;
		}else{
			$soid = $order->get_id();
		}

		if($column=='didar_status'){
			if($oid = get_post_meta( $soid,'didar_id',true )){
				echo '<span class="sent">ارسال شده</span>';
			}else
				echo '<span class="waiting">ارسال نشده</span>';
		}
	}


	function didar_send_order(){
		if($code=get_post_meta($_POST['oid'],'didar_id',true))
			wp_send_json([0,'این فاکتور قبلا ثبت شده است.']);	
		$didar = didar_api::save_order($_POST['oid']);
		if(isset($didar->Error)or isset($didar->Message)){
			didar_api::log_error($_POST['oid'], $didar, 'didar_send_order', 'WordPress');
			
			$error_msg = isset($didar->Message)?$didar->Message:$didar->Error;
			$error_code = isset($didar->Code)?$didar->Code:'';
			
			// Get detailed error info if available
			$operation_name = isset($didar->OperationInfo->OperationName) ? $didar->OperationInfo->OperationName : '';
			$endpoint = isset($didar->OperationInfo->Endpoint) ? $didar->OperationInfo->Endpoint : '';
			
			$detailed_msg = $error_msg;
			if($operation_name){
				$detailed_msg .= " (عملیات: $operation_name";
				if($endpoint){
					$detailed_msg .= " - Endpoint: $endpoint";
				}
				$detailed_msg .= ")";
			}
			if($error_code){
				$detailed_msg .= " [کد خطا: $error_code]";
			}
			
			wp_send_json([0,$detailed_msg]);
		}
		if(!is_object($didar))
			wp_send_json([0,$didar]);
		update_post_meta($_POST['oid'],'didar_id',$didar->Id);
		wp_send_json([1,'فاکتور با موفقیت ثبت شد.']);
	}

	function didar_send_all_order(){
		global $wpdb;
		$opt    = get_option( 'did_option', [] );
		$status = implode("','",$opt['status']);
		$oid    = empty($_POST['oid'])?0:$_POST['oid'];

		if( isHPOSenabled() ){

			$row = $wpdb->get_row("
		select * from {$wpdb->prefix}wc_orders o 
		where o.type='shop_order' and o.status in('$status') 
		and o.id>$oid and NOT EXISTS(select post_id from $wpdb->postmeta where post_id=o.id and meta_key='didar_id' and meta_value<>'') 
		order by id limit 1");

			if(empty($row))
				wp_send_json([2,'موردی یافت نشد.']);	
			$didar = didar_api::save_order($row->id);
			if(isset($didar->Message)or isset($didar->Error)){
				didar_api::log_error($row->id, $didar, 'didar_send_all_order', 'WordPress');
				$error_msg = isset($didar->Message)?$didar->Message:$didar->Error;
				wp_send_json([0,$error_msg."-$row->id",$row->id]);
			}
			if(isset($didar->Id)){
				update_post_meta($row->id,'didar_id',$didar->Id);
				wp_send_json([1,'فاکتور با موفقیت ثبت شد-'.$row->id,$row->id]);			
			}
			wp_send_json([0,$didar."-$row->id",$row->id]);

		}else{

			$row = $wpdb->get_row("
		select * from {$wpdb->prefix}posts o 
		where o.post_type='shop_order' and o.post_status in('$status') 
		and o.ID>$oid and NOT EXISTS(select post_id from $wpdb->postmeta where post_id=o.ID and meta_key='didar_id' and meta_value<>'') 
		order by ID limit 1");
			
			if(empty($row))
				wp_send_json([2,'موردی یافت نشد.']);	
			$didar = didar_api::save_order($row->ID);
			if(isset($didar->Message)or isset($didar->Error)){
				didar_api::log_error($row->ID, $didar, 'didar_send_all_order', 'WordPress');
				$error_msg = isset($didar->Message)?$didar->Message:$didar->Error;
				wp_send_json([0,$error_msg."-$row->ID",$row->ID]);
			}
			if(isset($didar->Id)){
				update_post_meta($row->ID,'didar_id',$didar->Id);
				wp_send_json([1,'فاکتور با موفقیت ثبت شد-'.$row->id,$row->ID]);			
			}
			wp_send_json([0,$didar."-$row->ID",$row->ID]);

		}

	}

	function didar_bulk_action_mark() {
		if(isset($_GET['page']) and $_GET['page']=='wc-orders')
?>
<script type="text/javascript">
	jQuery('.send_order_didar').click(function(){
		jQuery('.msg').hide();
		var td = jQuery(this).closest('td');
		td.find(".save_order_didar_wrapper").addClass('wait');
		jQuery.ajax({
			url:ajaxurl,
			type:'POST',
			data:{
				action:'didar_send_order',
				oid:jQuery(this).data('id')
			},
		}).done(function(data) {
			td.find(".save_order_didar_wrapper").removeClass('wait');
			//alert(data[1]);
			td.find('.msg').text(data[1]).show();
			if(data[0]==0)
				td.prev('td').html('<span class="waiting">ارسال نشده</span>');
			else
				td.prev('td').html('<span class="sent">ارسال شده</span>');
		});
	});
</script>
<?php
	}
}